# カボチャ
[カボチャ](objects/pumpkin)は耕された土でニンジンのように育ちます。植えるにはニンジンが必要です。

正方形内のすべてのカボチャが完全に成長すると、それらは一緒に成長して巨大なカボチャになります。残念ながら、カボチャは完全に成長すると20%の確率で枯れてしまうため、合体させたい場合は枯れたものを植え直す必要があります。

カボチャが枯れると、収穫しても何もドロップしない枯れたカボチャが残ります。その場所に新しい植物を植えると、枯れたカボチャは自動的に取り除かれるため、収穫する必要はありません。`can_harvest()` は枯れたカボチャに対して常に `False` を返します。

巨大なカボチャの収穫量は、カボチャのサイズによって異なります。

1x1のカボチャは `1*1*1 = 1` 個のカボチャを収穫します。
2x2のカボチャは `4` 個ではなく `2*2*2 = 8` 個のカボチャを収穫します。
3x3のカボチャは `9` 個ではなく `3*3*3 = 27` 個のカボチャを収穫します。
4x4のカボチャは `16` 個ではなく `4*4*4 = 64` 個のカボチャを収穫します。
5x5のカボチャは `25` 個ではなく `5*5*5 = 125` 個のカボチャを収穫します。
`n`x`n`のカボチャは `n >= 6` の場合、`n*n*6` 個のカボチャを収穫します。

完全な倍率を得るには、少なくとも6x6サイズのカボチャを手に入れるのが良いでしょう。

これは、正方形のすべてのタイルにカボチャを植えても、カボチャの1つが枯れてメガカボチャの成長を妨げる可能性があることを意味します。
